<?php 
	include "../../conn.php";
	include "../../functions2.php";
	
	header('Content-Type: application/json; charset=utf-8');
	header('Strict-Transport-Security: max-age=31536000');
	header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization');
	header('Access-Control-Allow-Credentials: true');
	$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';
	header('Access-Control-Allow-Origin: ' . $origin);
	header('vary: Origin');
	
	date_default_timezone_set("Asia/Kolkata");
	$shnunc = date("Y-m-d H:i:s");
	$res = [
		'code' => 11,
		'msg' => 'Method not allowed',
		'msgCode' => 12,
		'serviceNowTime' => $shnunc,
	];
	$shonubody = file_get_contents("php://input");
	$shonupost = json_decode($shonubody, true);
	
	if ($_SERVER['REQUEST_METHOD'] != 'GET') {
		if (isset($shonupost['amount']) && isset($shonupost['betCount']) && isset($shonupost['gameType']) && isset($shonupost['issuenumber']) && 
			isset($shonupost['language']) && isset($shonupost['random']) && isset($shonupost['selectType']) && isset($shonupost['signature']) && 
			isset($shonupost['timestamp']) && isset($shonupost['typeId'])) {
			$amount = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['amount']));
			$betCount = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['betCount']));
			$gameType = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['gameType']));
			$issuenumber = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['issuenumber']));
			$language = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['language']));
			$random = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['random']));
			$selectType = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['selectType']));
			$signature = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['signature']));
			$typeId = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['typeId']));
			$shonustr = '{"amount":'.$amount.',"betCount":'.$betCount.',"gameType":'.$gameType.',"issuenumber":"'.$issuenumber.'","language":'.$language.',"random":"'.$random.'","selectType":'.$selectType.',"typeId":'.$typeId.'}';
			$shonusign = strtoupper(md5($shonustr));
			if($shonusign == $signature){
				$bearer = explode(" ", $_SERVER['HTTP_AUTHORIZATION']);
				$author = $bearer[1];				
				$is_jwt_valid = is_jwt_valid($author);
				$data_auth = json_decode($is_jwt_valid, 1);
				if($data_auth['status'] === 'Success') {
                    $sesquery = "SELECT s.akshinak, s.hold_wallet, s.id, k.motta 
                               FROM shonu_subjects s
                               LEFT JOIN shonu_kaichila k ON s.id = k.balakedara
                               WHERE s.akshinak = '$author'";
                    $sesresult = $conn->query($sesquery);
                    $sesnum = mysqli_num_rows($sesresult);
                    
                    if($sesnum == 1){
                        $sesrow = mysqli_fetch_array($sesresult);
                        
                        // Calculate available balance considering hold amount
                        $totalBalance = $sesrow['motta'];
                        $heldAmount = $sesrow['hold_wallet'];
                        $availableBalance = $totalBalance - $heldAmount;

                        // Game type selection
                        if($typeId == 13){
                            $lordjesus = 'bajikattuttate_trx';
                            $sonofgod = 'gelluonduhogu_trx';
                        } else if($typeId == 14){
                            $lordjesus = 'bajikattuttate_trx3';
                            $sonofgod = 'gelluonduhogu_trx3';
                        } else if($typeId == 15){
                            $lordjesus = 'bajikattuttate_trx5';
                            $sonofgod = 'gelluonduhogu_trx5';
                        } else if($typeId == 16){
                            $lordjesus = 'bajikattuttate_trx10';
                            $sonofgod = 'gelluonduhogu_trx10';
                        }

                        if($betCount >= 1){
                            if($amount >= 1){
                                $samasye = "SELECT atadaaidi
                                          FROM ".$sonofgod."
                                          ORDER BY kramasankhye DESC LIMIT 1";
                                $samasyephalitansa = $conn->query($samasye);
                                $samasyesreni = mysqli_fetch_array($samasyephalitansa);
                                
                                if($samasyesreni['atadaaidi'] == $issuenumber){
                                    $totalamount = $amount * $betCount;

                                    // Check if available balance is sufficient
                                    if($availableBalance < $totalamount) {
                                        $res['code'] = 1;
                                        $res['msg'] = 'Insufficient available balance. Amount on hold: '.$heldAmount;
                                        $res['msgCode'] = 143;
                                        http_response_code(200);
                                        echo json_encode($res);
                                        exit;
                                    }

                                    if($availableBalance >= $totalamount){
                                        $byabaharkarta = $data_auth['payload']['id'];
                                        $sesabida = sprintf("%.2f", $totalamount * 0.98);
                                        
                                        $tathya = mysqli_query($conn,"INSERT INTO `".$lordjesus."` 
                                            (`byabaharkarta`,`kalaparichaya`,`prakar`,`ojana`,`menge`,
                                            `wettanzahl`,`ketebida`,`phalaphala`,`sesabida`,`tiarikala`) 
                                            VALUES ('".$byabaharkarta."','".$issuenumber."','".$gameType."',
                                            '".$selectType."','".$amount."','".$betCount."','".$totalamount."',
                                            'perte','".$sesabida."','".$shnunc."')");

                                        // Process rebate for this bet
                                        if($tathya) {
                                            $betId = mysqli_insert_id($conn);
                                            include "rebate_functions.php";
                                            createBetRebatesTable($conn);
                                            processBetRebate($conn, $byabaharkarta, $betId, $lordjesus, $totalamount, $shnunc);
                                        }

                                        // Update wallet balance
                                        $mottanutan = $totalBalance - $totalamount;
                                        $nabikarana = "UPDATE shonu_kaichila 
                                                     SET motta='$mottanutan' 
                                                     WHERE balakedara='$byabaharkarta'";
                                        $conn->query($nabikarana);

                                        include "commission.php";
                                        include "vip.php";
                                        
                                        $res['data'] = null;
                                        $res['code'] = 0;
                                        $res['msg'] = 'Succeed';
                                        $res['msgCode'] = 0;
                                        http_response_code(200);
                                        echo json_encode($res);
                                        exit;
                                    }
                                    
                                    $res['code'] = 1;
                                    $res['msg'] = 'Balance is not enough';
                                    $res['msgCode'] = 142;
                                    http_response_code(200);
                                    echo json_encode($res);
                                } else {
                                    $res['code'] = 1;
                                    $res['msg'] = 'The current period is settled';
                                    $res['msgCode'] = 404;
                                    http_response_code(200);
                                    echo json_encode($res);
                                }
                            } else {
                                $res['code'] = 7;
                                $res['msg'] = "Invalid value for parameter 'Amount'";
                                unset($res['msgCode']);
                                unset($res['serviceNowTime']);
                                http_response_code(200);
                                echo json_encode($res);
                            }
                        } else {
                            $res['code'] = 7;
                            $res['msg'] = "Invalid value for parameter 'BetCount'";
                            unset($res['msgCode']);
                            unset($res['serviceNowTime']);
                            http_response_code(200);
                            echo json_encode($res);
                        }
                    } else {
                        $res['code'] = 4;
                        $res['msg'] = 'No operation permission';
                        $res['msgCode'] = 2;
                        http_response_code(401);
                        echo json_encode($res);
                    }
                } else {
                    $res['code'] = 4;
                    $res['msg'] = 'No operation permission';
                    $res['msgCode'] = 2;
                    http_response_code(401);
                    echo json_encode($res);
                }
            } else {
                $res['code'] = 5;
                $res['msg'] = 'Wrong signature';
                $res['msgCode'] = 3;
                http_response_code(200);
                echo json_encode($res);
            }
        } else {
            $res['code'] = 7;
            $res['msg'] = 'Param is Invalid';
            $res['msgCode'] = 6;
            http_response_code(200);
            echo json_encode($res);
        }
    } else {
        http_response_code(405);
        echo json_encode($res);
    }
?>